"""logo"""
import os
import random


ingram_icon = r"""
          _    __..-:┑
   ║`====╩=╩=======╣ |
==#║_______███_/ @ ║ |
   ╚===.===╦==╦=╤==╩#█
       \___║::║/      
           ║::║|      
           ║::║|      
           ║::║_\     
            ██        
            ██        
            ██        
            ██        
            ██        
"""


ingram_fonts = [
r"""
 ___                                    
|_ _|  _ _    __ _   _ _   __ _   _ __  
 | |  | ' \  / _` | | '_| / _` | | '  \ 
|___| |_||_| \__, | |_|   \__,_| |_|_|_|
             |___/                      
""",

r"""
**                                                        
/**               *****                                    
/**   *******    **///**   ******    ******     ********** 
/**  //**///**  /**  /**  //**//*   //////**   //**//**//**
/**   /**  /**  //******   /** /     *******    /** /** /**
/**   /**  /**   /////**   /**      **////**    /** /** /**
/**   ***  /**    *****   /***     //********   *** /** /**
//   ///   //    /////    ///       ////////   ///  //  // 
""",

r"""
[..                                                     
[..                                                     
[.. [.. [..      [..    [. [...    [..     [... [.. [.. 
[..  [..  [..  [..  [..  [..     [..  [..   [..  [.  [..
[..  [..  [.. [..   [..  [..    [..   [..   [..  [.  [..
[..  [..  [..  [..  [..  [..    [..   [..   [..  [.  [..
[.. [...  [..      [..  [...      [.. [... [...  [.  [..
                [..                                     
""",

r"""
M""M                                                      
M  M                                                     
M  M  88d888b.  .d8888b.  88d888b.  .d8888b.  88d8b.d8b. 
M  M  88'  `88  88'  `88  88'  `88  88'  `88  88'`88'`88 
M  M  88    88  88.  .88  88        88.  .88  88  88  88 
M  M  dP    dP  `8888P88  dP        `88888P8  dP  dP  dP 
MMMM                 .88                                 
                d8888P                                  
""",

r"""
__  .__   __.   _______  .______            ___      .___  ___. 
|  | |  \ |  |  /  _____| |   _  \          /   \     |   \/   | 
|  | |   \|  | |  |  __   |  |_)  |        /  ^  \    |  \  /  | 
|  | |  . `  | |  | |_ |  |      /        /  /_\  \   |  |\/|  | 
|  | |  |\   | |  |__| |  |  |\  \----.  /  _____  \  |  |  |  | 
|__| |__| \__|  \______|  | _| `._____| /__/     \__\ |__|  |__| 
""",

r"""
d888888b  d8b   db   d888b   d8888b.   .d8b.   .88b  d88. 
  `88'    888o  88  88' Y8b  88  `8D  d8' `8b  88'YbdP`88 
   88     88V8o 88  88       88oobY'  88ooo88  88  88  88 
   88     88 V8o88  88  ooo  88`8b    88~~~88  88  88  88 
  .88.    88  V888  88. ~8~  88 `88.  88   88  88  88  88 
Y888888P  VP   V8P   Y888P   88   YD  YP   YP  YP  YP  YP 
""",

r"""
8888888                                                            
  888                                                              
  888                                                              
  888    88888b.    .d88b.   888d888 8888b.   88888b.d88b.  
  888    888 "88b  d88P"88b  888P"      "88b  888 "888 "88b 
  888    888  888  888  888  888    .d888888  888  888  888 
  888    888  888  Y88b 888  888    888  888  888  888  888 
8888888  888  888   "Y88888  888    "Y888888  888  888  888 
                        888                                  
                   Y8b d88P                                  
                    "Y88P"                                   
""",

r"""
|''||''|                                                
   ||                                                   
   ||     `||''|,   .|''|,  '||''|   '''|.   '||),,(|,  
   ||      ||  ||   ||  ||   ||     .|''||    || || ||  
|..||..|  .||  ||.  `|..||  .||.    `|..||.  .||    ||. 
                        ||                              
                     `..|'                              
""",

r"""
@@@   @@@  @@@    @@@@@@@@   @@@@@@@     @@@@@@    @@@@@@@@@@   
@@@   @@@@ @@@   @@@@@@@@@   @@@@@@@@   @@@@@@@@   @@@@@@@@@@@  
@@!   @@!@!@@@   !@@         @@!  @@@   @@!  @@@   @@! @@! @@!  
!@!   !@!!@!@!   !@!         !@!  @!@   !@!  @!@   !@! !@! !@!  
!!@   @!@ !!@!   !@! @!@!@   @!@!!@!    @!@!@!@!   @!! !!@ @!@  
!!!   !@!  !!!   !!! !!@!!   !!@!@!     !!!@!!!!   !@!   ! !@!  
!!:   !!:  !!!   :!!   !!:   !!: :!!    !!:  !!!   !!:     !!:  
:!:   :!:  !:!   :!:   !::   :!:  !:!   :!:  !:!   :!:     :!:  
 ::    ::   ::    ::: ::::   ::   :::   ::   :::   :::     ::   
:     ::    :     :: :: :     :   : :    :   : :    :      :    
""",

r"""
                  ___           ___           ___           ___           ___     
      ___        /\__\         /\  \         /\  \         /\  \         /\__\    
     /\  \      /::|  |       /::\  \       /::\  \       /::\  \       /::|  |   
     \:\  \    /:|:|  |      /:/\:\  \     /:/\:\  \     /:/\:\  \     /:|:|  |   
     /::\__\  /:/|:|  |__   /:/  \:\  \   /::\~\:\  \   /::\~\:\  \   /:/|:|__|__ 
  __/:/\/__/ /:/ |:| /\__\ /:/__/_\:\__\ /:/\:\ \:\__\ /:/\:\ \:\__\ /:/ |::::\__\
 /\/:/  /    \/__|:|/:/  / \:\  /\ \/__/ \/_|::\/:/  / \/__\:\/:/  / \/__/~~/:/  /
 \::/__/         |:/:/  /   \:\ \:\__\      |:|::/  /       \::/  /        /:/  / 
  \:\__\         |::/  /     \:\/:/  /      |:|\/__/        /:/  /        /:/  /  
   \/__/         /:/  /       \::/  /       |:|  |         /:/  /        /:/  /   
                 \/__/         \/__/         \|__|         \/__/         \/__/    
""",

r"""
                  ___           ___           ___           ___           ___     
      ___        /  /\         /  /\         /  /\         /  /\         /  /\    
     /__/\      /  /::|       /  /::\       /  /::\       /  /::\       /  /::|   
     \__\:\    /  /:|:|      /  /:/\:\     /  /:/\:\     /  /:/\:\     /  /:|:|   
     /  /::\  /  /:/|:|__   /  /:/  \:\   /  /::\ \:\   /  /::\ \:\   /  /:/|:|__ 
  __/  /:/\/ /__/:/ |:| /\ /__/:/_\_ \:\ /__/:/\:\_\:\ /__/:/\:\_\:\ /__/:/_|::::\
 /__/\/:/~~  \__\/  |:|/:/ \  \:\__/\_\/ \__\/~|::\/:/ \__\/  \:\/:/ \__\/  /~~/:/
 \  \::/         |  |:/:/   \  \:\ \:\      |  |:|::/       \__\::/        /  /:/ 
  \  \:\         |__|::/     \  \:\/:/      |  |:|\/        /  /:/        /  /:/  
   \__\/         /__/:/       \  \::/       |__|:|~        /__/:/        /__/:/   
                 \__\/         \__\/         \__\|         \__\/         \__\/    
""",

r"""
 _______                                           
|_     _| .-----. .-----. .----. .---.-. .--------.
 _|   |_  |     | |  _  | |   _| |  _  | |        |
|_______| |__|__| |___  | |__|   |___._| |__|__|__|
                  |_____|                          
""",

r"""
_|_|_|                                                         
  _|    _|_|_|      _|_|_|  _|  _|_|   _|_|_|  _|_|_|  _|_|    
  _|    _|    _|  _|    _|  _|_|     _|    _|  _|   |_|    _|  
  _|    _|    _|  _|    _|  _|       _|    _|  _|   |_|    _|  
_|_|_|  _|    _|    _|_|_|  _|         _|_|_|  _|    _|    _|  
                        _|                                      
                    _|_|                                        
""",

r"""
'####::::'##::: ##:::::'######::::::'########::::::::'###:::::::'##::::'##:
. ##::::: ###:: ##::::'##... ##::::: ##.... ##::::::'## ##:::::: ###::'###:
: ##::::: ####: ##:::: ##:::..:::::: ##:::: ##:::::'##:. ##::::: ####'####:
: ##::::: ## ## ##:::: ##::'####:::: ########:::::'##:::. ##:::: ## ### ##:
: ##::::: ##. ####:::: ##::: ##::::: ##.. ##:::::: #########:::: ##. #: ##:
: ##::::: ##:. ###:::: ##::: ##::::: ##::. ##::::: ##.... ##:::: ##:.:: ##:
'####:::: ##::. ##::::. ######:::::: ##:::. ##:::: ##:::: ##:::: ##:::: ##:
....:::::..::::..::::::......:::::::..:::::..:::::..:::::..:::::..:::::..::
""",

r"""
:::  :::.    :::.    .,-:::::/    :::::::..       :::.       .        :   
;;;  `;;;;,  `;;;  ,;;-'````'     ;;;;``;;;;      ;;`;;      ;;,.    ;;;  
[[[    [[[[[. '[[  [[[   [[[[[[/   [[[,/[[['     ,[[ '[[,    [[[[, ,[[[[, 
$$$    $$$ "Y$c$$  "$$c.    "$$    $$$$$$c      c$$$cc$$$c   $$$$$$$$"$$$ 
888    888    Y88   `Y8bo,,,o88o   888b "88bo,   888   888,  888 Y88" 888o
MMM    MMM     YM     `'YMUP"YMM   MMMM   "W"    YMM   ""`   MMM  M'  "MMM
""",

r"""
_/\/\/\/\_________________________________________________________________
___/\/\____/\/\/\/\______/\/\/\/\__/\/\__/\/\__/\/\/\______/\/\/\__/\/\___
___/\/\____/\/\__/\/\__/\/\__/\/\__/\/\/\/\________/\/\____/\/\/\/\/\/\/\_
___/\/\____/\/\__/\/\____/\/\/\/\__/\/\________/\/\/\/\____/\/\__/\__/\/\_
_/\/\/\/\__/\/\__/\/\________/\/\__/\/\________/\/\/\/\/\__/\/\______/\/\_
_______________________/\/\/\/\___________________________________________
""",

r"""
    ____                                              
   /  _/  ____     ____ _   _____   ____ _   ____ ___ 
   / /   / __ \   / __ `/  / ___/  / __ `/  / __ `__ \
 _/ /   / / / /  / /_/ /  / /     / /_/ /  / / / / / /
/___/  /_/ /_/   \__, /  /_/      \__,_/  /_/ /_/ /_/ 
                /____/                                
""",

r"""
 ___                                      
|   |.-----..-----..----..---.-..--------.
|.  ||     ||  _  ||   _||  _  ||        |
|.  ||__|__||___  ||__|  |___._||__|__|__|
|:  |       |_____|                       
|::.|                                     
`---'                                     
""",

r"""
O))                                                     
O))                                                     
O)) O)) O))      O))    O) O)))    O))     O))) O)) O)) 
O))  O))  O))  O))  O))  O))     O))  O))   O))  O)  O))
O))  O))  O)) O))   O))  O))    O))   O))   O))  O)  O))
O))  O))  O))  O))  O))  O))    O))   O))   O))  O)  O))
O)) O)))  O))      O))  O)))      O)) O))) O)))  O)  O))
                O))                                     
""",

r"""
     _/\/\/\/\____________________________________________________________________
    ___/\/\_____/\/\/\/\______/\/\/\/\___/\/\__/\/\___/\/\/\______/\/\/\__/\/\___ 
   ___/\/\_____/\/\__/\/\__/\/\__/\/\___/\/\/\/\_________/\/\____/\/\/\/\/\/\/\_  
  ___/\/\_____/\/\__/\/\____/\/\/\/\___/\/\_________/\/\/\/\____/\/\__/\__/\/\_   
 _/\/\/\/\___/\/\__/\/\________/\/\___/\/\_________/\/\/\/\/\__/\/\______/\/\_    
________________________/\/\/\/\____________________________________________     
""",

r"""
 ______                                                            
/\__  _\                                                           
\/_/\ \/        ___         __      _ __      __        ___ ___    
   \ \ \      /' _ `\     /'_ `\   /\`'__\  /'__`\    /' __` __`\  
    \_\ \__   /\ \/\ \   /\ \L\ \  \ \ \/  /\ \L\.\_  /\ \/\ \/\ \ 
    /\_____\  \ \_\ \_\  \ \____ \  \ \_\  \ \__/.\_\ \ \_\ \_\ \_\
    \/_____/   \/_/\/_/   \/___L\ \  \/_/   \/__/\/_/  \/_/\/_/\/_/
                            /\____/                                
                            \_/__/                                 
""",

r"""
 _____                                      
|     |   ___    ___    ___    ___    _____ 
|-   -|  |   |  | . |  |  _|  | .'|  |     |
|_____|  |_|_|  |_  |  |_|    |__,|  |_|_|_|
                |___|                       
""",

r"""
.___                                                
|   |   ____      ____   _______  _____      _____  
|   |  /    \    / ___\  \_  __ \ \__  \    /     \ 
|   | |   |  \  / /_/  >  |  | \/  / __ \_ |  Y Y  \
|___| |___|  /  \___  /   |__|    (____  / |__|_|  /
           \/  /_____/                 \/        \/ 
""",

r"""
:::::::::::  ::::    :::   ::::::::   :::::::::       :::      ::::    ::::  
    :+:      :+:+:   :+:  :+:    :+:  :+:    :+:    :+: :+:    +:+:+: :+:+:+ 
    +:+      :+:+:+  +:+  +:+         +:+    +:+   +:+   +:+   +:+ +:+:+ +:+ 
    +#+      +#+ +:+ +#+  :#:         +#++:++#:   +#++:++#++:  +#+  +:+  +#+ 
    +#+      +#+  +#+#+#  +#+   +#+#  +#+    +#+  +#+     +#+  +#+       +#+ 
    #+#      #+#   #+#+#  #+#    #+#  #+#    #+#  #+#     #+#  #+#       #+# 
###########  ###    ####   ########   ###    ###  ###     ###  ###       ### 
""",

r"""
.-.                                           
: :                                           
: :  ,-.,-.   .--.   .--.    .--.    ,-.,-.,-.
: :  : ,. :  ' .; :  : ..'  ' .; ;   : ,. ,. :
:_;  :_;:_;  `._. ;  :_;    `.__,_;  :_;:_;:_;
              .-. :                           
              `._.'                           
""",

r"""
oooo__________________________________________________________
_oo_____oo_ooo______oooo______oo_ooo______ooooo_____oo_oo_oo__
_oo_____ooo___o____oo__oo_____ooo___o____oo___oo____ooo_oo__o_
_oo_____oo____o____oo___o_____oo_________oo___oo____oo__oo__o_
_oo_____oo____o_____oooooo____oo_________oo___oo____oo__oo__o_
oooo____oo____o____o____oo____oo__________oooo_o____oo______o_
____________________ooooo_____________________________________
""",

r"""
ooooo                                                                          
`888'                                                                  
 888   ooo. .oo.     .oooooooo  oooo d8b   .oooo.    ooo. .oo.  .oo.   
 888   `888P"Y88b   888' `88b   `888""8P  `P  )88b   `888P"Y88bP"Y88b  
 888    888   888   888   888    888       .oP"888    888   888   888  
 888    888   888   `88bod8P'    888      d8(  888    888   888   888  
o888o  o888o o888o  `8oooooo.   d888b     `Y888""8o  o888o o888o o888o 
                    d"     YD                                          
                    "Y88888P'                                          
""",

r"""
:::  :::.    :::.    .,-:::::/    :::::::..       :::.       .        :   
;;;  `;;;;,  `;;;  ,;;-'````'     ;;;;``;;;;      ;;`;;      ;;,.    ;;;  
[[[    [[[[[. '[[  [[[   [[[[[[/   [[[,/[[['     ,[[ '[[,    [[[[, ,[[[[, 
$$$    $$$ "Y$c$$  "$$c.    "$$    $$$$$$c      c$$$cc$$$c   $$$$$$$$"$$$ 
888    888    Y88   `Y8bo,,,o88o   888b "88bo,   888   888,  888 Y88" 888o
MMM    MMM     YM     `'YMUP"YMM   MMMM   "W"    YMM   ""`   MMM  M'  "MMM
""",
]


def generate_logo() -> list:
    """concatenate the icon and font"""
    icon = [i for i in ingram_icon.split('\n') if i.strip()]
    icon_width = max([len(i) for i in icon])
    icon = [' ' * icon_width] + icon + [' ' * icon_width]
    icon_height = len(icon)

    # do not longger than the terminal width!!!
    found = False
    for _ in range(100):
        font = random.choice(ingram_fonts).split('\n')
        font_width = max([len(i) for i in font])
        font_height = len(font)
        try:
            if font_width + icon_width + 2 < os.get_terminal_size()[0]:
                found = True
                break
        except:
            found = True
            break
    if not found:
        font = ['']
        font_height = 1

    if icon_height > font_height:
        num = icon_height - font_height
        if num & 1: head, tail = num // 2, num // 2 + 1
        else: head, tail = num // 2, num // 2
        font = [' '] * head + font + [' '] * tail
    
    elif icon_height < font_height:
        num = font_height - icon_height
        if num & 1: head, tail = num // 2, num // 2 + 1
        else: head, tail = num // 2, num // 2
        icon = [' ' * icon_width] * head + icon + [' ' * icon_width] * tail
    
    return [icon, font]


logo = generate_logo()


if __name__ == '__main__':
    for left, right in zip(*logo):
        print(f"{left}  {right}")